//
//  Login.swift
//  Orbis
//
//  Created by KALSI on 6/22/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift
import MessageUI
import Security
import Alamofire
import Reachability



class Login: UIViewController, UITextFieldDelegate {

    @IBOutlet weak var emailTF: UITextField!
    @IBOutlet weak var emailView: UIView!
    @IBOutlet weak var loginButtonView: UIView!

    @IBOutlet weak var loader: UIView!
    @IBOutlet weak var otpTF: UITextField!
    @IBOutlet weak var otpView: UIView!
    
    @IBOutlet weak var indicator: UIActivityIndicatorView!
    
    //MARK:-
    override func viewDidLoad() {
        super.viewDidLoad()
        
        if UserDefaults.standard.bool(forKey: "isLogged") == true {

        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        appDelegate.transVC = storyboard.instantiateViewController(withIdentifier: "LoaderVW") as! LoaderVW
            appDelegate.transVC.view.tag = 999
            let reachability = Reachability()!
            
            do{
                try reachability.startNotifier()
            }catch{
                print("could not start reachability notifier")
            }
            reachability.whenReachable = { reachability in
                if reachability.connection == .wifi {
                    print("Reachable via WiFi")
                    
                } else {
                    print("Reachable via Cellular")
                }
                appDelegate.window?.addSubview(appDelegate.transVC.view)

            }
        }
        //View Attributes
        RoundOff(view: emailView)
        
        otpView.layer.cornerRadius = 10
        otpView.layer.masksToBounds = true
        
//        TrainingManual_VC
        
        let trainingView = self.storyboard?.instantiateViewController(withIdentifier: "TrainingManual")
        self.addChildViewController(trainingView!)
        
        if UserDefaults.standard.object(forKey: "wantTraining") == nil {
            self.view.addSubview((trainingView?.view)!)

        }
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    override func viewWillLayoutSubviews() {
    }
    //MARK:- Functions -
    func RoundOff(view : UIView) {
        view.layer.cornerRadius = view.frame.height / 2
        view.layer.masksToBounds = true
    }
    
    //MARK:- Web Services-
    func web_ForgotPassword() {
        //Service
    }
    
    //MARK:- UITextFieldDelegate -
    public func textFieldShouldReturn(_ textField: UITextField) -> Bool{
        if textField == emailTF {
            emailTF.resignFirstResponder()
        }
        return true
    }
    
    //MARK:- IBActions -
    @IBAction func LoginAction(_ sender: Any) {
        if emailTF.text == ""{
            Globals().TextFieldWarning(textField: emailTF)
        }else if (emailTF.text?.characters.count)! < 10 {
            Globals().addPrompt(message: "Invalid phone number!", view: self, completion: {  })
        }else{
            
            self.loader.isHidden = false
            self.otpView.isHidden = true
            self.indicator.isHidden = false
            
            
            print("\(baseURL)user/login_asm/?number=\(emailTF.text!)")
            if Globals().checkLocationAuthorization(selectedView: self){
                
                
                Globals.Services().AlamofireGet(method: "user/", parameters: ["number":"\(emailTF.text!)"], completion: { (result) in
                    
                    print(result)
                    let response = LoginData().setData(result)
                    
                    if response.status == "1" {
                        self.indicator.isHidden = true
                        self.otpView.isHidden = false
                    }else{
                        self.loader.isHidden = true
                        Globals().addPrompt(message: "\(response.message)", view: self, completion: {  })
                    }
                }, failure: { (fail) in
                    print(fail)
                })
            }else{
                self.indicator.isHidden = true
                self.loader.isHidden = true
                
            }
        }
        }
    
    @IBAction func OTPActions(_ sender: UIButton) {
        switch sender.tag {
        case 1:
            loader.isHidden = true
            break
        case 2:
            if otpTF.text != ""{
                self.loader.isHidden = false
                self.otpView.isHidden = true
                self.indicator.isHidden = false
                
                let dict = ["number":"\(emailTF.text!)","app_type":"Orbis" ,"device_type":"ios", "device_token":appDelegate.iPhnToken, "otp":"\(otpTF.text!)","device_id":"0"]

                Globals.Services().AlamofirePost("user/verify_otp", parameters: dict as NSDictionary, completion: { (result) in

                    let response = VerificationData().setData(result)
                    print("mhere\(result)")
                    
                    if response.status == "1" {
                        self.loader.isHidden = true
                        Globals().addPrompt(message: "Login successful!", view: self, completion: {
                            UserDefaults.standard.set(self.emailTF.text!, forKey: "userContact")
                            UserDefaults.standard.set(true, forKey: "isLogged")
                          
                            
                            UserDefaults.standard.set(response.refId, forKey: "userRefID")
                            UserDefaults.standard.set(response.prfImgUrl, forKey: "prfImgUrl")

                            UserDefaults.standard.synchronize()
                            Globals().SendSignalToARC(controllerObject:self , signalType: Constants.sLogin)

                          //  Globals().SetLocationDelegate()
                            appDelegate.isAmberTimer = false
                            appDelegate.startUpdatingLocation()
//                            let vc = self.storyboard?.instantiateViewController(withIdentifier: "TabController") as! TabController
//                            self.navigationController?.pushViewController(vc, animated: true)
                            
                         
                            appDelegate.navigateToDashboard()
                        })
                    }else{
                        self.otpView.isHidden = false
                        self.indicator.isHidden = true
                        Globals().addPrompt(message: "Please enter correct OTP", view: self, completion: {
                        })
                    }
                })
                
            }else{
                Globals().TextFieldWarning(textField: otpTF)
            }
            break
        default:
            break
        }
    }
    
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        controller.dismiss(animated: true, completion: nil)
    }
    
    
    }
